﻿using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.JSON.LitJson;
using PI.ZB.N1200.ELearning.BL.API.Model;

namespace PI.ZB.N1200.ELearning.BL.API
{
    /// <summary>
    /// Bazowe informacje zawierajace oryginalna odpowiedx z API
    /// </summary>
    public class GResponseBase
    {
        private List<GError> _errorList = new List<GError>();
        private GData _data = new GData();


        /// <summary>
        /// Rodzajmetody dla jakiej jest odpowiedz
        /// </summary>
        public MethodCodeType MethodCode { get; internal set; }

        /// <summary>
        /// Oryginalny komunikat odpowiedzi
        /// </summary>
        public string Raw { get; internal set; }

        /// <summary>
        /// Komunikat bledu powstaly na skutek wewnetrznego przetwarzania odpowiedzi
        /// (parsowania) do obiektow
        /// </summary>
        public string InternalExceptionMessage { get; internal set; }

        /// <summary>
        /// Lista bledow
        /// </summary>
        public List<GError> errorList
        {
            get { return _errorList; }
            set { _errorList = value; }
        }

        /// <summary>
        /// Bazowe dane zwiazane z uwierzytelnianiem
        /// </summary>
        public GData data
        {
            get { return _data; }
            set { _data = value; }
        }
    }

    /// <summary>
    /// Odpowiedz z API
    /// </summary>
    public class GResponse<T> : GResponseBase
        where T : GObject, new()
    {
        private T _requestData = new T();
        private T _responseData = new T();

        public GResponse()
        {
        }

        /// <summary>
        /// Obiekt zawierajacy zapytanie
        /// </summary>
        public T requestData
        {
            get { return _requestData; }
            set { _requestData = value; }
        }

        /// <summary>
        /// Obiekt zawierajacy odpowiedz
        /// </summary>
        public T responseData
        {
            get { return _responseData; }
            set { _responseData = value; }
        }
    }
}
